--------------------------------------------------------------------------
--
-- gpio_if.vhd
--
-- 'Driver' for the GPIO headers
--
-- Autor: Nial Stewartwhen Nial Stewart Developments Ltd
-- Date : 09/08/08
--
-- Rev  : 01
--
--------------------------------------------------------------------------
-- Trivially simple tri-state and IO control for the GPIO header ports.
-- This could have been done at the top level but keeping things in this
-- module keeps things neater.
--------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity gpio_if is
port (
      -- Interface to pins
      gpio            : inout std_logic_vector(7 downto 0);
      -- Control Signals
      gpio_dir        : in std_logic_vector(7 downto 0);  -- Direction (ie tristate) control
      gpio_dout       : in std_logic_vector(7 downto 0);  -- Data output to pins
      gpio_din        : out std_logic_vector(7 downto 0) -- Data read from pins

      );
end gpio_if;

architecture rtl of gpio_if is


begin

-- Allow individual pin direction control
opt_dir:for i in 0 to 7 generate
  gpio(i) <= gpio_dout(i) when gpio_dir(i) = '1' else 'Z';
end generate;

-- Input's easy to read.

gpio_din <= gpio;

-- That's it, hardly worth bothering!

end rtl;
