--------------------------------------------------------------------------
-- slave_if.vhd
--
-- Author : Nial Stewart, Nial Stewart Developments Ltd
--          www.nialstewartdevelopments.co.uk
-- Date   : 07/02/2006
--
--
--------------------------------------------------------------------------
-- This is the very simple slave section of the ds1821 interface. The
-- control signals are generated by the 'master' section of the interface,
-- then one of these slaves is instantiated per sensor being interfaced.
-- This keeps the 'footprint' required per sensor low, increasing the number
-- of sensors that can be driven with a given amount of FPGA logic.
--------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity ds1821_if_slave is
port (
      rst           : in std_logic;
      clk           : in std_logic;  -- 50MHz system clock

      -- Control inputs
      detect_sensor : in std_logic;
      get_bit       : in std_logic;
      output_reading: in std_logic;

      -- Outputs
      temp          : out std_logic_vector(7 downto 0);
      -- 1 wire interface only needs 1 wire!

      dq            : in std_logic
      );
end ds1821_if_slave;

architecture rtl of ds1821_if_slave is

signal shift_reg      : std_logic_vector(7 downto 0);
signal sensor_present : std_logic;


begin

process(clk,rst)
begin
if(rst = '1') then
  shift_reg       <= (others => '0');

elsif(rising_edge(clk)) then
  if(detect_sensor = '1') then
    sensor_present <= not(dq);
  end if;

  if(detect_sensor = '1') then
    shift_reg <= (others => '0');
  elsif(get_bit = '1') then
    shift_reg(7) <= dq;
    shift_reg(6 downto 0) <= shift_reg(7 downto 1);
  end if;

  if(output_reading = '1') then
    if(sensor_present = '0') then
      temp <= x"C9";
    else
      temp <= shift_reg;
    end if;
  end if;

end if;
end process;




end rtl;
